package mcfall.raytracer;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import net.miginfocom.swing.MigLayout;

public class PixelInfoBox extends JPanel {
	private static final int OUTSIDE_BORDER = 10;
	private JLabel pixelLocation;
	private JLabel pixelColor;
	
	public PixelInfoBox () {
		super (new MigLayout ());
		pixelLocation = new JLabel ("Location: ");		
		pixelColor = new JLabel ("Color: ");
		add(pixelLocation);		
		add(pixelColor, "gapbefore " + 2*OUTSIDE_BORDER);		
	}
	
	public void setInfo (final int x, final int y, final int red, final int green, final int blue) {
		SwingUtilities.invokeLater( new Runnable () {
			public void run () {
				pixelLocation.setText("Location: " + x + ", " + y);
				pixelColor.setText("Color: " + red + ", " + green + ", " + blue);
			}
		});
	}
}
